-- Interception (Hook) for the file ...\ZomboWin\media\lua\client\ZomboWin\ZomboWinAnimationHandler.lua
-- Interception of functions ISAnimationAction:stop() and ISAnimationAction:perform()
-- Safety precaution in case the SFXBackgroundStop event did not have time to be triggered.

-- Check that ISAnimationAction exists
if not ISAnimationAction then
    return
end

-- Save the old original functions
local old_stop = ISAnimationAction.stop
local old_perform = ISAnimationAction.perform

-- Redefine stop()
function ISAnimationAction:stop()
    -- Stop ALL sounds in case of interruption (e.g. voluntarily by the player with right click + space)
    -- pcall(require, ...) avoids any crash if for some reason shared is not available.
	local ok, shared = pcall(require, "ZomboWin/ZomboWinAnimationAddonSFXBackgroundShared")
    -- Test if shared and shared.soundID check that the sound was playing before trying to stop it.
	if ok and shared and shared.soundIDs then
        for _, id in ipairs(shared.soundIDs) do
            self.character:stopOrTriggerSound(id)
        end
        shared.soundIDs = {}
        print("[ZomboWinAddOn] Safety: All sounds stopped following interruption (stop).")
    end

    -- Call the old normal function
    old_stop(self)
end

-- Redefine perform()
function ISAnimationAction:perform()
    -- Stop ALL sounds in case of normal end of animation
    -- pcall(require, ...) avoids any crash if for some reason shared is not available.
    local ok, shared = pcall(require, "ZomboWin/ZomboWinAnimationAddonSFXBackgroundShared")
    -- Test if shared and shared.soundID check that the sound was playing before trying to stop it.
    if ok and shared and shared.soundIDs then
        for _, id in ipairs(shared.soundIDs) do
            self.character:stopOrTriggerSound(id)
        end
        shared.soundIDs = {}
        print("[ZomboWinAddOn] Safety: All sounds stopped at the end of the animation (perform).")
    end

    -- Call the old normal function
    old_perform(self)
end